#!/bin/bash

# Check if the user provided a directory name as an argument
if [ -z "$1" ]; then
  echo "Usage: $0 <directory_name>"
  exit 1
fi

# Set the user-provided parameter to the PROJECT_DIR variable
PROJECT_DIR="$1"

# Try to create a directory named PROJECT_DIR
if ! mkdir "$PROJECT_DIR"; then
  echo "Failed: Unable to create directory $PROJECT_DIR. Exiting..."
  exit 1
fi

# Change to the newly created directory
cd "$PROJECT_DIR"

# Create an empty index.html file
touch index.html

# Create a directory named src
mkdir src

# Create a subdirectory named components inside the src directory
mkdir src/components

# Create a file named my-element.js in the components directory
touch src/components/my-element.js

# Create a file named main.js
touch src/main.js