from flask import Flask, Response
from prometheus_client import Counter, Summary, generate_latest, CONTENT_TYPE_LATEST
import time

app = Flask(__name__)

# 自訂 metrics
REQUEST_COUNT = Counter('app_requests_total', 'Total number of requests')
REQUEST_LATENCY = Summary('app_request_latency_seconds', 'Request latency')

@app.route('/')
@REQUEST_LATENCY.time()  # 測量延遲
def hello():
    REQUEST_COUNT.inc()  # 計數器 +1
    time.sleep(0.2)      # 模擬延遲
    return "Hello World!"

@app.route("/metrics")
def metrics():
    return Response(generate_latest(), mimetype=CONTENT_TYPE_LATEST)

if __name__ == '__main__':
    app.run(host='0.0.0.0', port=8000)