import sys

class PythonVersionChecker:
    def __init__(self, supported_versions):
        self.supported_versions = supported_versions

    def get_current_version(self):
        """取得當前的 Python 版本。"""
        return sys.version_info[:2]

    def is_supported(self):
        """檢查當前的 Python 版本是否在支援的版本列表中。"""
        current_version = self.get_current_version()
        return current_version in self.supported_versions

class StreamlitVersionChecker(PythonVersionChecker):
    def __init__(self):
        # 定義 Streamlit 支援的 Python 版本
        supported_versions = [(3, 9), (3, 10), (3, 11), (3, 12), (3, 13)]
        super().__init__(supported_versions)

    def check_version(self):
        """檢查並輸出當前的 Python 版本是否受 Streamlit 支援。"""
        current_version = self.get_current_version()
        if self.is_supported():
            print(f"當前的 Python 版本 {current_version[0]}.{current_version[1]} 受 Streamlit 支援。")
        else:
            print(f"當前的 Python 版本 {current_version[0]}.{current_version[1]} 不受 Streamlit 支援。")

# 使用範例
checker = StreamlitVersionChecker()
checker.check_version()

