setup_venv() {
    VENV_DIR="myenv"

    if [ -d "$VENV_DIR" ]; then
        echo "虛擬環境 '$VENV_DIR' 已經存在。"
    else
        echo "正在建立虛擬環境 '$VENV_DIR'..."
        python3 -m venv "$VENV_DIR"
        echo "虛擬環境已建立。"
    fi

    echo "啟動虛擬環境..."
    source "$VENV_DIR/bin/activate"

    echo "正在升級 pip..."
    pip install --upgrade pip
    echo "pip 已升級。"

    if [ -f "requirements.txt" ]; then
        echo "正在安裝 requirements.txt 中的依賴..."
        pip install -r requirements.txt
        echo "依賴已安裝。"
    fi

    echo "虛擬環境設定完成。"
}