#!/bin/bash

# 設定虛擬環境名稱
VENV_DIR="myenv"

# 檢查是否已經存在虛擬環境
if [ -d "$VENV_DIR" ]; then
    echo "虛擬環境 '$VENV_DIR' 已經存在。"
else
    echo "正在建立虛擬環境 '$VENV_DIR'..."
    python3 -m venv "$VENV_DIR"
    echo "虛擬環境已建立。"
fi

# 啟動虛擬環境
echo "啟動虛擬環境..."
source "$VENV_DIR/bin/activate"

# 升級 pip
echo "正在升級 pip..."
pip install --upgrade pip
echo "pip 已升級。"

# 安裝 requirements.txt 中的依賴（如果存在）
if [ -f "requirements.txt" ]; then
    echo "正在安裝 requirements.txt 中的依賴..."
    pip install -r requirements.txt
    echo "依賴已安裝。"
fi

echo "虛擬環境設定完成。"