#!/bin/bash

# 測試 API /data 端點的 curl 測試 script
# Usage: ./test_api.sh '2025-01-01 00:00:00' '2025-01-02 00:00:00'

API_URL="http://127.0.0.1:5000/data"
API_KEY="your_generic_api_key_here"  # 請替換成正確的 API 金鑰

if [ "$#" -lt 2 ]; then
  echo "Usage: $0 <start_time> <end_time>"
  echo "Example: $0 '2025-01-01 00:00:00' '2025-01-02 00:00:00'"
  exit 1
fi

START_TIME="$1"
END_TIME="$2"

# 將時間中的空格轉換成 URL 可讀格式
ENCODED_START=$(echo "$START_TIME" | sed 's/ /%20/g')
ENCODED_END=$(echo "$END_TIME" | sed 's/ /%20/g')

curl -H "Authorization: Bearer $API_KEY" \
     "$API_URL?start=$ENCODED_START&end=$ENCODED_END"
