# 專案簡介

本專案展示如何整合環境變數管理、日誌系統、資料庫連線封裝與 API 設計，並透過 Flask 框架提供 RESTful 服務。專案強調資源管理與安全驗證的流程，適合用於建立穩定且安全的後端服務。

---

## 初始化與環境設定

1. **環境變數讀取**  
   程式啟動時會使用 `dotenv` 載入 .env 檔案中的設定，包含 API 金鑰、資料庫連線參數、日誌等級及密鑰等。

2. **日誌工具設定**  
   利用 loguru 設定日誌輸出，記錄連線狀態與錯誤資訊，方便追蹤與除錯。

---

## 資料庫連線模組

1. **BaseDatabase 類別**  
   封裝與資料庫互動的基本流程，包含建立連線、執行 SQL 查詢、將查詢結果轉換為 DataFrame 以及正確關閉連線。

2. **子類別擴展**  
   根據不同資料庫（如 SQL Server、SQLite、MySQL），定義各自的子類別，依資料庫連線格式產生合適的連線 URL，並調用 BaseDatabase 功能。

---

## 資料庫連線管理

- **get_db 函式**  
  從環境變數中讀取 SQL Server 的連線參數，建立資料庫連線實例，確保每次請求都能根據設定取得正確的連線。

---

## Flask 應用程式建立與配置

1. **建立 Flask 應用**  
   透過 `create_app()` 函式建立並配置 Flask 應用，並設定必要參數（例如 SECRET_KEY）。

2. **生命週期鉤子**
   - **before_request**：每個 HTTP 請求前，請透過 `get_db()` 初始化資料庫連線，並將連線存放於全域變數 `g` 中。
   - **teardown_request**：請求結束後，不論是否發生錯誤，都會關閉資料庫連線，以確保資源正確釋放。

---

## API 路由與邏輯處理

1. **API 金鑰驗證**  
   請在進入 API 邏輯前，透過 `validate_api_key()` 驗證請求是否包含正確的 API 金鑰，以保護 API 存取權限。

2. **資料查詢 API (`/data`)**

   - 接收 `start` 與 `end` 兩個時間參數，並驗證其格式是否正確。
   - 根據提供的時間區間構造 SQL 查詢，從資料表中抓取符合條件的資料。
   - 查詢結果將轉換為 Pandas DataFrame，最終以 JSON 格式回傳給請求端。

3. **健康檢查 API (`/health`)**  
   提供一個簡單的端點來回報服務狀態，常用於監控或自動化健康檢查。

---

## 主程式執行

- **使用 Waitress 啟動服務**  
  主程式區塊中將建立好的 Flask 應用交由 Waitress 伺服器運行，使服務能在指定主機與埠口上穩定提供 HTTP 服務。

---

整體而言，此專案展示了如何整合多項技術與流程，達成穩定、安全的後端服務。請依據實際需求進行修改與擴充，如有任何問題，歡迎提出討論。
