#!/bin/bash

# manage_swappiness.sh
# 簡單又好用的 Linux swappiness 管理小工具

# 檢查是否有 root 權限
if [ "$EUID" -ne 0 ]; then
  echo "嘿，這個腳本需要 root 權限喔！試試用 sudo 來執行吧。"
  exit 1
fi

# 顯示當前的 swappiness 值
function show_swappiness() {
  echo "現在系統的 swappiness 值是: $(cat /proc/sys/vm/swappiness)"
}

# 設置臨時 swappiness 值
function set_temp_swappiness() {
  read -p "請輸入臨時 swappiness 值 (0-100): " value
  if [[ "$value" =~ ^[0-9]+$ ]] && [ "$value" -ge 0 ] && [ "$value" -le 100 ]; then
    sysctl vm.swappiness=$value
    echo "好的，臨時 swappiness 值已經設置為 $value 了！(重啟後會還原喔)"
  else
    echo "額... 這個數字不對吧？請輸入 0 到 100 之間的數字。"
  fi
}

# 設置永久 swappiness 值
function set_permanent_swappiness() {
  read -p "請輸入永久 swappiness 值 (0-100): " value
  if [[ "$value" =~ ^[0-9]+$ ]] && [ "$value" -ge 0 ] && [ "$value" -le 100 ]; then
    sed -i '/^vm.swappiness/d' /etc/sysctl.conf
    echo "vm.swappiness=$value" >> /etc/sysctl.conf
    sysctl -p
    echo "OK！永久 swappiness 值已經設置為 $value，系統會保持這個設定。"
  else
    echo "嗯... 這個數字不太對吧？記得要輸入 0 到 100 之間的數字喔！"
  fi
}

# 顯示選單
function show_menu() {
  echo ""
  echo "===== swappiness 小幫手 ====="
  echo "1. 查看當前 swappiness 值"
  echo "2. 設置臨時 swappiness 值"
  echo "3. 設置永久 swappiness 值"
  echo "4. 離開腳本"
  echo "============================="
}

# 主程序循環
while true; do
  show_menu
  read -p "請選擇操作 (1-4): " choice
  case $choice in
    1) show_swappiness ;;
    2) set_temp_swappiness ;;
    3) set_permanent_swappiness ;;
    4) echo "掰掰！希望這個小工具對你有幫助！"; exit 0 ;;
    *) echo "哎呀，請輸入 1 到 4 之間的數字喔！" ;;
  esac
done
