import streamlit as st
import yaml
import pandas as pd
from io import StringIO

# 定義讀取 YAML 文件的函數
def read_yaml(file_path):
    with open(file_path, 'r') as file:
        return yaml.safe_load(file)

# 定義寫入 YAML 文件的函數
def write_yaml(file_path, data):
    with open(file_path, 'w') as file:
        yaml.dump(data, file, default_flow_style=False)

# 讀取 YAML 文件
file_path = 'data.yml'
data = read_yaml(file_path)

# 將 YAML 資料轉換為 DataFrame
data_df = pd.DataFrame([data])

# 使用 st.data_editor 編輯資料
edited_data_df = st.data_editor(data_df)

# 如果資料有變更，更新 YAML 文件
if st.button('Save'):
    edited_data = edited_data_df.iloc[0].to_dict()
    write_yaml(file_path, edited_data)
    st.success('Data saved successfully!')

# 顯示編輯後的資料
st.write('Edited Data:', edited_data_df)

