-- 查詢當前 SQL Server 的總連線數以及不同 IP 來源的連線數
SELECT 
    COUNT(*) AS TotalConnections,  -- 計算總連線數
    COUNT(DISTINCT client_net_address) AS UniqueIPs  -- 計算不同來源 IP 的數量
FROM sys.dm_exec_connections;

-- 查詢所有當前連線的詳細資訊
SELECT 
    session_id,          -- 連線的會話 ID
    connect_time,        -- 連線建立的時間
    client_net_address,  -- 連線的客戶端 IP 地址
    local_net_address,   -- 伺服器端的本地 IP 地址
    local_tcp_port,      -- 伺服器端的本地 TCP 連接埠
    protocol_type,       -- 連線使用的通訊協定（如 TCP、Named Pipes）
    encrypt_option       -- 連線的加密選項（如 TRUE/FALSE）
FROM sys.dm_exec_connections
ORDER BY connect_time DESC;  -- 按連線時間排序，最新的在最上方

-- 計算每個客戶端 IP 的連線數量
SELECT 
    client_net_address,  -- 客戶端 IP 地址
    COUNT(*) AS ConnectionCount  -- 來自該 IP 的連線數量
FROM sys.dm_exec_connections
GROUP BY client_net_address
ORDER BY ConnectionCount DESC;  -- 按連線數量排序，最多的在最上方

-- 查詢所有處於 "sleeping" 狀態的會話，並統計記憶體使用情況
SELECT 
    program_name,  -- 連線所使用的程式名稱（如 SQL Server Management Studio、應用程式名稱）
    COUNT(*) AS SessionCount,  -- 該程式產生的 "sleeping" 會話數量
    SUM(memory_usage) * 8 AS TotalMemory_KB,  -- 計算總記憶體使用量（KB）
    SUM(memory_usage) * 8 / 1024 AS TotalMemory_MB  -- 計算總記憶體使用量（MB）
FROM sys.dm_exec_sessions
WHERE status = 'sleeping'  -- 過濾僅查詢 "sleeping" 狀態的會話
GROUP BY program_name
ORDER BY TotalMemory_KB DESC;  -- 按記憶體使用量排序，使用最多的在最上方
