import streamlit as st

# 多國語系字典
LANGUAGES = {
    "zh": {
        "title": "簡單計算器",
        "instruction": "請輸入兩個數字，選擇運算方式：",
        "num1": "數字 1",
        "num2": "數字 2",
        "operation": "選擇運算方式",
        "add": "加法 (+)",
        "subtract": "減法 (-)",
        "calculate": "計算",
        "result": "結果：",
        "error": "請輸入有效的數字。",
    },
    "en": {
        "title": "Simple Calculator",
        "instruction": "Enter two numbers and choose an operation:",
        "num1": "Number 1",
        "num2": "Number 2",
        "operation": "Choose Operation",
        "add": "Addition (+)",
        "subtract": "Subtraction (-)",
        "calculate": "Calculate",
        "result": "Result:",
        "error": "Please enter valid numbers.",
    },
}

# 語言選項
language_options = {"中文": "zh", "English": "en"}
selected_language = st.sidebar.selectbox(
    "Select Language", list(language_options.keys())
)
lang = language_options[selected_language]
T = LANGUAGES[lang]

# 顯示標題與說明
st.title(T["title"])
st.write(T["instruction"])

# 取得用戶輸入的數字
num1 = st.text_input(T["num1"])
num2 = st.text_input(T["num2"])

# 運算選項
operation = st.selectbox(
    T["operation"], [T["add"], T["subtract"]]
)

# 計算按鈕
if st.button(T["calculate"]):
    try:
        n1 = float(num1)
        n2 = float(num2)
        if operation == T["add"]:
            result = n1 + n2
        else:
            result = n1 - n2
        st.success(f"{T['result']} {result}")
    except ValueError:
        st.error(T["error"])
