# 匯入 Flask 框架，用於建立 Web 應用程式
from flask import Flask
import argparse  # 匯入 argparse 來解析命令列參數

# 建立 Flask 應用程式實例
app = Flask(__name__)

# 定義根路由，當用戶訪問 "/" 時返回 "Hello, Flask!"
@app.route('/')
def home():
    return "Hello, Flask!"

# 入口點：僅當此檔案以主程式運行時才會執行
if __name__ == '__main__':
    # 設定命令列參數解析器
    parser = argparse.ArgumentParser(description="啟動 Flask 伺服器")
    parser.add_argument('--port', type=int, default=5000, help='指定 Flask 伺服器埠號 (預設為 5000)')
    
    # 解析參數
    args = parser.parse_args()

    # 啟動 Flask 應用程式，監聽所有網卡 (0.0.0.0)，允許外部訪問
    # threaded=True 啟用多執行緒模式，提高併發能力
    app.run(host='0.0.0.0', port=args.port, threaded=True)
