from dataclasses import dataclass, field

@dataclass
class Employee:
    name: str
    salary: float
    department: str = "General"
    
    def __post_init__(self):
        self.salary = round(self.salary, 2)  # 四捨五入薪資
    
employee = Employee(name="Alice", salary=1234.5678)
print(employee)  # Employee(name='Alice', salary=1234.57, department='General')
