from flask import Flask, redirect, url_for, session
from authlib.integrations.flask_client import OAuth
import os
from dotenv import load_dotenv

load_dotenv()
app = Flask(__name__)
app.secret_key = "your_secret_key"  # 必須設置 Secret Key

oauth = OAuth(app)

# 註冊 Google OAuth2 提供者，使用 discovery endpoint 自動獲取 metadata
google = oauth.register(
    name='google',
    client_id=os.getenv("GOOGLE_CLIENT_ID"),
    client_secret=os.getenv("GOOGLE_CLIENT_SECRET"),
    server_metadata_url='https://accounts.google.com/.well-known/openid-configuration',
    client_kwargs={
        'scope': 'openid profile email',
    }
)

@app.route('/')
def homepage():
    return '歡迎！<a href="/login">使用 Google 登入</a>'

@app.route('/login')
def login():
    # 生成一個隨機 nonce，作為一次性驗證令牌
    nonce = os.urandom(16).hex()
    session['nonce'] = nonce
    # 將 nonce 傳遞給 authorize_redirect
    return google.authorize_redirect(url_for('auth', _external=True), nonce=nonce)

@app.route('/auth')
def auth():
    token = google.authorize_access_token()
    # 從 session 中取得先前生成的 nonce
    nonce = session.get('nonce')
    # 將 nonce 傳入以驗證 ID Token
    user_info = google.parse_id_token(token, nonce=nonce)
    return f"歡迎, {user_info['name']}！"

if __name__ == '__main__':
    app.run(debug=True)
