import secrets
import string

def generate_sk_key(length=32, segment_length=8):
    """
    生成一個以 'sk-' 開頭的安全金鑰，包含字母和數字，隨機性高。
    length: 總長度（不包含 'sk-' 前綴）
    segment_length: 每段長度，用 '-' 分隔
    """
    # 定義可用字符：大小寫字母 + 數字
    characters = string.ascii_letters + string.digits  # 包含 a-z, A-Z, 0-9
    # 生成隨機字符
    random_part = ''.join(secrets.choice(characters) for _ in range(length))
    # 分段處理，用 '-' 分隔
    segments = [random_part[i:i + segment_length] for i in range(0, length, segment_length)]
    key = 'sk-' + '-'.join(segments)
    return key

# 生成並印出金鑰
secure_key = generate_sk_key(length=32)
print(f"Generated Secure Key: {secure_key}")