#!/bin/bash
# 檔名：check_iscsi_status.sh

TARGET_IP="192.168.42.20"

echo "🔍 檢查是否能 ping 到 Synology..."
ping -c 2 $TARGET_IP || {
  echo "❌ 無法連線到 $TARGET_IP"
  exit 1
}

echo "🔍 檢查 iscsid 服務狀態..."
systemctl is-active --quiet iscsid || {
  echo "⚠️ iscsid 沒有運作，嘗試啟動中..."
  systemctl unmask iscsid
  systemctl enable --now iscsid
}

echo "🔍 目前 iSCSI sessions:"
iscsiadm -m session || echo "⚠️ 尚未登入任何 target"

echo "🔍 執行 SendTargets 探測:"
iscsiadm -m discovery -t sendtargets -p $TARGET_IP

echo "🔍 顯示 LVM 狀態:"
pvs && vgs && lvs
