-- 建立一個名為 your_table_name 的資料表，並加上 Table 註解
CREATE TABLE your_table_name (
    id INT PRIMARY KEY AUTO_INCREMENT,           -- 自動遞增的主鍵
    name VARCHAR(100) NOT NULL                   -- 使用者名稱（不可為 NULL）
)
COMMENT = '這是儲存使用者基本資訊的資料表';       -- Table 註解

-- 修改 your_table_name 的 Table 註解為新內容
ALTER TABLE your_table_name
COMMENT = '更新後的資料表註解內容';

-- 清除 your_table_name 的 Table 註解
ALTER TABLE your_table_name
COMMENT = '';

-- 顯示 your_table_name 的完整狀態資訊，其中包含 Comment 欄位
SHOW TABLE STATUS
WHERE Name = 'your_table_name'\G

-- 從 INFORMATION_SCHEMA 查詢指定 Table 的 Comment
SELECT TABLE_COMMENT
FROM INFORMATION_SCHEMA.TABLES
WHERE TABLE_SCHEMA = DATABASE()
  AND TABLE_NAME = 'your_table_name';

--------------------------------------------------------------------------------

-- 建立 users 資料表，同時為每個欄位加上 Column 註解
CREATE TABLE users (
  id INT PRIMARY KEY AUTO_INCREMENT COMMENT '使用者唯一識別碼',      -- 主鍵
  name VARCHAR(100) NOT NULL COMMENT '使用者姓名',                   -- 使用者全名
  email VARCHAR(255) UNIQUE COMMENT '使用者電子郵件地址'              -- 唯一電子郵件
);

-- 修改 users 表中 name 欄位的註解（需重述完整欄位定義）
ALTER TABLE users 
MODIFY COLUMN name VARCHAR(100) NOT NULL COMMENT '全名（First + Last）';

-- 移除 users 表中 name 欄位的註解（設為空字串）
ALTER TABLE users 
MODIFY COLUMN name VARCHAR(100) NOT NULL COMMENT '';

-- 顯示 users 表所有欄位及其詳細資訊（包含 Comment 欄位）
SHOW FULL COLUMNS FROM users;

-- 從 INFORMATION_SCHEMA 查詢 users 表所有欄位的名稱與註解
SELECT COLUMN_NAME, COLUMN_COMMENT
FROM INFORMATION_SCHEMA.COLUMNS
WHERE TABLE_SCHEMA = DATABASE()
  AND TABLE_NAME = 'users';
