import streamlit as st
import pandas as pd
import yaml
from yaml.loader import SafeLoader

# Read YAML file
def read_yaml(file_path):
    with open(file_path, 'r') as file:
        data = yaml.load(file, Loader=SafeLoader)
    return data

# Write to YAML file
def write_yaml(file_path, data):
    with open(file_path, 'w') as file:
        yaml.dump(data, file)

# Read data
yaml_file = 'data.yaml'
data = read_yaml(yaml_file)

# Convert data to DataFrame
df = pd.DataFrame(data['employees'])

# Display DataFrame
st.write('## Employee Data Table')
st.write(df)

# Allow user to edit data
st.write('## Edit Employee Data')
edited_df = st.data_editor(df)

# When user submits edits, write data back to YAML file
if st.button('Save Changes'):
    data['employees'] = edited_df.to_dict(orient='records')
    write_yaml(yaml_file, data)
    st.success('Changes saved successfully!')

# Hide certain columns
columns_to_hide = ['Salary']
df_visible = df.drop(columns=columns_to_hide)

# Display DataFrame with hidden columns
st.write('## Employee Data Table (Filtered)')
st.write(df_visible)

# Interaction: Slider
age_filter = st.slider('Select age range', 20, 30, (20, 30))

# Filter DataFrame
filtered_df = df_visible[(df_visible['Age'] >= age_filter[0]) & (df_visible['Age'] <= age_filter[1])]

# Display filtered DataFrame
st.write('## Filtered Employee Data Table')
st.write(filtered_df)

