import streamlit as st
import pandas as pd
import yaml
from yaml.loader import SafeLoader

# 讀取 YAML 檔案
def read_yaml(file_path):
    with open(file_path, 'r') as file:
        data = yaml.load(file, Loader=SafeLoader)
    return data

# 寫入 YAML 檔案
def write_yaml(file_path, data):
    with open(file_path, 'w') as file:
        yaml.dump(data, file)

# 讀取資料
yaml_file = 'data.yaml'
data = read_yaml(yaml_file)

# 轉換資料為 DataFrame
df = pd.DataFrame(data['employees'])

# 顯示 DataFrame
st.write('## 員工資料表')
st.write(df)

# 允許用戶編輯資料，並隱藏 City 欄位
st.write('## 編輯員工資料')
edited_df = st.data_editor(df.drop(columns=['City']))

# 當用戶提交修改後，將資料寫回 YAML 檔案，但要保留 City 欄位
if st.button('儲存修改'):
    edited_df['City'] = df['City']  # 將原始資料中的 City 欄位加回來
    data['employees'] = edited_df.to_dict(orient='records')
    write_yaml(yaml_file, data)
    st.success('修改成功儲存！')

# 隱藏某些欄位
columns_to_hide = ['Salary']
df_visible = df.drop(columns=columns_to_hide)

# 顯示隱藏某些欄位後的 DataFrame
st.write('## 員工資料表 (過濾後)')
st.write(df_visible)

# 互動元素：滑桿
age_filter = st.slider('選擇年齡範圍', 20, 30, (20, 30))

# 篩選 DataFrame
filtered_df = df_visible[(df_visible['Age'] >= age_filter[0]) & (df_visible['Age'] <= age_filter[1])]

# 顯示篩選後的 DataFrame
st.write('## 過濾後的員工資料表')
st.write(filtered_df)
