class AnnualLeaveCalculator:
    def __init__(self, employment_date, current_date):
        """
        初始化特休計算器
        :param employment_date: 入職日期，格式為 'YYYY-MM-DD'
        :param current_date: 目前日期，格式為 'YYYY-MM-DD'
        """
        self.employment_date = employment_date
        self.current_date = current_date

    def calculate_years_of_service(self):
        """計算服務年資"""
        from datetime import datetime
        start_date = datetime.strptime(self.employment_date, '%Y-%m-%d')
        end_date = datetime.strptime(self.current_date, '%Y-%m-%d')
        delta = end_date - start_date
        years_of_service = delta.days / 365.25  # 考慮閏年
        return years_of_service

    def calculate_annual_leave(self):
        """根據服務年資計算特休天數"""
        years = self.calculate_years_of_service()
        if years < 0.5:
            return 0
        elif 0.5 <= years < 1:
            return 3
        elif 1 <= years < 2:
            return 7
        elif 2 <= years < 3:
            return 10
        elif 3 <= years < 5:
            return 14
        elif 5 <= years < 10:
            return 15
        else:
            additional_days = min(int(years - 10), 15)
            return 15 + additional_days

# 測試範例
if __name__ == "__main__":
    calculator = AnnualLeaveCalculator('2016-08-08', '2025-02-07')
    print(f"應享有的特休天數: {calculator.calculate_annual_leave()} 天")

