# 定義一個字典 days，將數字對應到星期幾的名稱
days = {
    "1": "Monday",
    "2": "Tuesday",
    "3": "Wednesday",
    "4": "Thursday",
    "5": "Friday",
    "6": "Saturday",
    "7": "Sunday",
}


# 定義一個字典 wk_map，將數字對應到縮寫的星期幾名稱
wk_map = {
    "1": "Mon",
    "2": "Tues",
    "3": "Wed",
    "4": "Thu",
    "5": "Fri",
    "6": "Sat",
    "7": "Sun",
}

# 定義一個字典，將數字對應到縮寫的月份名稱
months = {
    1: "Jan",
    2: "Feb",
    3: "Mar",
    4: "Apr",
    5: "May",
    6: "Jun",
    7: "Jul",
    8: "Aug",
    9: "Sep",
    10: "Oct",
    11: "Nov",
    12: "Dec",
}


# 定義一個二維列表 operators，包含了各種比較運算符及其對應的表示方式
_operators = [
    ["ge ", ">="],
    ["le ", "<="],
    ["lt ", "<"],
    ["gt ", ">"],
    ["ne ", "!="],
    ["eq ", "="],
    ["contains "],
    ["datestartswith "],
]


# 定義一個函數來使用 operators
def apply_operator(operator, a, b):
    for op in _operators:
        if operator in op:
            if operator == "ge ":
                return a >= b
            elif operator == "le ":
                return a <= b
            elif operator == "lt ":
                return a < b
            elif operator == "gt ":
                return a > b
            elif operator == "ne ":
                return a != b
            elif operator == "eq ":
                return a == b
            elif operator == "contains ":
                return a in b
            elif operator == "datestartswith ":
                return b.startswith(a)
    return "Operator not found"


# 檢查當前程式是否被作為主程式執行
if __name__ == "__main__":
    # 使用days字典將數字轉換為星期幾的名稱
    day_number = "3"
    day_name = days.get(day_number, "Unknown")
    print(f"The day corresponding to number {day_number} is: {day_name}")

    # 使用wk_map字典將數字轉換為縮寫的星期幾名稱
    weekday_number = "2"
    weekday_abbreviation = wk_map.get(weekday_number, "Unknown")
    print(f"The abbreviation for weekday number {weekday_number} is: {weekday_abbreviation}")  # fmt: skip

    # 使用months字典將數字轉換為縮寫的月份名稱
    month_number = 3
    month_abbreviation = months.get(month_number, "Unknown")
    print(f"The abbreviation for month number {month_number} is: {month_abbreviation}")

    # 使用函數
    print(apply_operator("ge ", 5, 3))  # True
    print(apply_operator("lt ", 5, 3))  # False
    print(apply_operator("contains ", "test", "this is a test"))  # True
    print(apply_operator("datestartswith ", "2024", "2024-03-22"))  # True
