from typing import Any, Dict, List, Optional, Tuple, Union

# 函式使用型別註解
def process_data(
    data: List[Dict[str, Union[int, float]]],
    metadata: Optional[Dict[str, Any]] = None
) -> Tuple[int, float]:
    """計算資料的總和與平均值"""
    total = sum(item["value"] for item in data)
    avg = total / len(data) if data else 0
    return total, avg

# 測試資料
sample_data = [{"value": 10}, {"value": 20}, {"value": 30}]
result = process_data(sample_data)

print(f"總和: {result[0]}, 平均值: {result[1]:.2f}")
