# 設定 LAN 網路的 IP 地址
uci set network.lan.ipaddr='192.168.1.1'
# 設定 LAN 網路的子網路遮罩
uci set network.lan.netmask='255.255.255.0'

# 設定 WAN 網路的閘道器 IP 地址
uci set network.wan.gateway='192.168.1.1'

# 提交並保存網路配置變更
uci commit network

# 重新啟動網路服務以應用新配置
/etc/init.d/network restart

# 啟用無線網路
uci set wireless.radio0.disabled='0'
# 設定無線網路的 SSID
uci set wireless.radio0.ssid='MyWiFi'
# 設定無線網路的加密方式
uci set wireless.radio0.encryption='psk2'
# 設定無線網路的密碼
uci set wireless.radio0.key='mypassword'
# 提交並保存無線網路配置變更
uci commit wireless
# 重新啟動無線網路服務
wifi

# 啟用 DHCP 服務
uci set dhcp.lan.ignore='0'
# 設定 DHCP 服務的起始 IP 地址
uci set dhcp.lan.start='100'

# 設定 DHCP 服務的 IP 地址數量
uci set dhcp.lan.limit='150'
# 提交並保存 DHCP 配置變更
uci commit dhcp
# 重新啟動 DHCP 服務
/etc/init.d/dnsmasq restart

# 設定防火牆允許 LAN 網路轉發
uci set firewall.lan.forward='ACCEPT'
# 新增防火牆規則
uci add firewall rule
# 設定防火牆規則的名稱
uci set firewall.@rule[-1].name='Allow-HTTP'
# 設定防火牆規則的來源
uci set firewall.@rule[-1].src='wan'
# 設定防火牆規則的目的地
uci set firewall.@rule[-1].dest='lan'
# 設定防火牆規則的目的地端口
uci set firewall.@rule[-1].dest_port='80'
# 設定防火牆規則的協議
uci set firewall.@rule[-1].proto='tcp'
# 設定防火牆規則的目標
uci set firewall.@rule[-1].target='ACCEPT'
# 提交並保存防火牆配置變更
uci commit firewall
# 重新啟動防火牆服務
/etc/init.d/firewall restart

# 設定系統的主機名稱
uci set system.@system[0].hostname='MyRouter'
# 設定系統的時區
uci set system.@system[0].timezone='UTC-8'
# 提交並保存系統配置變更
uci commit system

# 獲取 LAN 網路的 IP 地址
uci get network.lan.ipaddr
# 顯示所有網路配置
uci show network

# 刪除 LAN 網路的 IP 地址
uci delete network.lan.ipaddr
# 提交並保存網路配置變更
uci commit network
