from typing import NamedTuple

class Person(NamedTuple):
    name: str
    age: int
    email: str

# 建立實例
person1 = Person(name="Timmy", age=30, email="timmy@example.com")

# 存取欄位值（像是屬性一樣）
print(person1.name)   # Timmy
print(person1.age)    # 30
print(person1.email)  # timmy@example.com

# NamedTuple 也是可被解包的（像一般 tuple）
name, age, email = person1
print(f"{name} is {age} years old. Email: {email}")
