import re

# 定義正規表示式模式
pattern = r"\b[A-Za-z0-9._%+-]+@[A-Za-z0-9.-]+\.[A-Z|a-z]{2,}\b"

# 測試字串
text = "聯絡我們: support@example.com 或 visit@example.org"

# 搜尋第一個匹配的電子郵件
match = re.search(pattern, text)
if match:
    print(f"找到電子郵件: {match.group()}")

# 找出所有匹配的電子郵件
matches = re.findall(pattern, text)
print(f"所有找到的電子郵件: {matches}")

# 取代電子郵件為 [隱藏]
masked_text = re.sub(pattern, "[隱藏]", text)
print(f"隱藏處理後的文字: {masked_text}")
