SHOW DATABASES;

USE myapp;
SHOW TABLES;

SELECT TABLE_NAME, TABLE_ROWS
FROM INFORMATION_SCHEMA.TABLES
WHERE TABLE_SCHEMA = 'myapp';

SELECT TABLE_NAME,
       ROUND((DATA_LENGTH + INDEX_LENGTH) / 1024 / 1024, 2) AS SIZE_MB
FROM INFORMATION_SCHEMA.TABLES
WHERE TABLE_SCHEMA = 'myapp'
ORDER BY SIZE_MB DESC;

SELECT TABLE_NAME,
       TABLE_ROWS AS RECORDS,
       ROUND((DATA_LENGTH + INDEX_LENGTH) / 1024 / 1024, 2) AS SIZE_MB
FROM INFORMATION_SCHEMA.TABLES
WHERE TABLE_SCHEMA = 'myapp'
ORDER BY SIZE_MB DESC;

SELECT TABLE_SCHEMA AS DATABASE_NAME,
       TABLE_NAME,
       TABLE_ROWS AS RECORDS,
       ROUND((DATA_LENGTH + INDEX_LENGTH) / 1024 / 1024, 2) AS SIZE_MB
FROM INFORMATION_SCHEMA.TABLES
ORDER BY DATABASE_NAME, SIZE_MB DESC;
