from fastapi import FastAPI, Header, Depends, HTTPException

app = FastAPI()

def verify_token(api_key: str = Header(None)):
    if api_key != "my_secure_token":
        raise HTTPException(status_code=403, detail="存取被拒絕")
    return api_key

@app.get("/protected-resource")
async def protected_resource(token: str = Depends(verify_token)):
    return {"message": "驗證成功", "token": token}

# 測試：
# curl -H "api-key: my_secure_token" http://127.0.0.1:8000/protected-resource

