#!/usr/bin/env bash

# ===== 顏色設定 =====
RED="\033[31m"
GREEN="\033[32m"
YELLOW="\033[33m"
CYAN="\033[36m"
RESET="\033[0m"

# ===== 專案 Logo（ASCII Art）=====
show_logo() {
  echo -e "${CYAN}"
  echo "   ____             _           "
  echo "  |  _ \ ___   ___ | | ___  ___ "
  echo "  | |_) / _ \ / _ \| |/ _ \/ __|"
  echo "  |  __/ (_) | (_) | |  __/\__ \\"
  echo "  |_|   \___/ \___/|_|\___||___/"
  echo -e "${RESET}"
}

# ===== 權限檢查與自動 sudo =====
require_root() {
  if [[ $EUID -ne 0 ]]; then
    echo -e "${YELLOW}需要 root 權限，將自動以 sudo 重新執行...${RESET}"
    if command -v sudo >/dev/null 2>&1; then
      exec sudo "$0" "$@"
    else
      echo -e "${RED}找不到 sudo，請手動以 root 執行。${RESET}"
      exit 1
    fi
  fi
}

# ===== 用 curl --head 測試檔案網址 =====
check_url_exists() {
  local url="$1"
  if curl --head --silent --fail "$url" >/dev/null; then
    echo -e "${GREEN}網址存在：${url}${RESET}"
    return 0
  else
    echo -e "${YELLOW}找不到檔案：${url}${RESET}"
    return 1
  fi
}

# ===== 主程式入口 main =====
main() {
  show_logo

  require_root "$@"

  # 範例網址測試
  FILE_URL1="https://example.com/file.txt"
  FILE_URL2="https://example.com/file_backup.txt"

  if ! check_url_exists "$FILE_URL1"; then
    echo -e "${CYAN}嘗試第二個網址...${RESET}"
    if ! check_url_exists "$FILE_URL2"; then
      echo -e "${RED}兩個網址都無法存取，請檢查連線或檔案名稱。${RESET}"
      exit 2
    fi
  fi

  echo -e "${GREEN}腳本執行完成！${RESET}"
}

# ===== 執行主程式 =====
main "$@"
