import inspect

def example_function(a: int, b: str = "default") -> bool:
    """示範函式，回傳 True 或 False"""
    return bool(a)

# 獲取函式參數
signature = inspect.signature(example_function)
print(f"函式簽名: {signature}")

for name, param in signature.parameters.items():
    print(f"參數名稱: {name}, 類型: {param.annotation}, 預設值: {param.default}")

# 獲取函式的文件字串
print(f"函式說明: {inspect.getdoc(example_function)}")
