import inspect

class SampleClass:
    """這是一個示範類別"""
    def method_one(self):
        """方法一"""
        pass
    
    def method_two(self, x: int) -> str:
        """方法二，回傳字串"""
        return str(x)

# 獲取類別的說明
print(f"類別說明: {inspect.getdoc(SampleClass)}")

# 列出類別的所有方法
methods = inspect.getmembers(SampleClass, predicate=inspect.isfunction)
for name, method in methods:
    print(f"方法名稱: {name}, 方法簽名: {inspect.signature(method)}")
