#!/bin/bash

echo "===== [ 系統基本資訊 ] ====="
echo "作業系統: $(lsb_release -d | cut -f2)"
echo "核心版本: $(uname -r)"
echo "CPU 型號: $(lscpu | grep 'Model name' | sed 's/Model name:\s*//')"
echo "CPU 核心數: $(nproc)"
echo "記憶體狀態:"
free -h

echo ""
echo "===== [ 檔案描述符資訊 ] ====="
echo "當前最大開啟檔案數: $(ulimit -n)"
echo "系統允許最大開啟檔案數: $(cat /proc/sys/fs/file-max)"
echo "當前已開啟檔案數量: $(cat /proc/sys/fs/file-nr | awk '{print $1}')"

echo ""
echo "===== [ 網路設定 ] ====="
echo "最大接受緩衝區 (rmem_max): $(sysctl -n net.core.rmem_max)"
echo "最大傳輸緩衝區 (wmem_max): $(sysctl -n net.core.wmem_max)"
echo "最大網路佇列 (netdev_max_backlog): $(sysctl -n net.core.netdev_max_backlog)"
echo "最大 socket 連線數 (somaxconn): $(sysctl -n net.core.somaxconn)"

echo ""
echo "===== [ TCP 設定 ] ====="
echo "TCP TIME_WAIT 重用: $(sysctl -n net.ipv4.tcp_tw_reuse)"
echo "TCP FIN_TIMEOUT: $(sysctl -n net.ipv4.tcp_fin_timeout)"
echo "TCP SYN 佇列長度: $(sysctl -n net.ipv4.tcp_max_syn_backlog)"
echo "TCP 快速開啟 (Fast Open): $(sysctl -n net.ipv4.tcp_fastopen)"
echo "TCP 擁塞控制演算法: $(sysctl -n net.ipv4.tcp_congestion_control)"

echo ""
echo "===== [ 連線追蹤 (Conntrack) 設定 ] ====="
echo "最大連線追蹤數: $(sysctl -n net.netfilter.nf_conntrack_max)"
echo "當前連線追蹤數: $(cat /proc/sys/net/netfilter/nf_conntrack_count)"

echo ""
echo "===== [ 當前開啟的 TCP 連線 ] ====="
echo "總 TCP 連線數: $(netstat -ant | wc -l)"
echo "TIME_WAIT 連線數: $(netstat -ant | grep TIME_WAIT | wc -l)"
echo "ESTABLISHED 連線數: $(netstat -ant | grep ESTABLISHED | wc -l)"

echo ""
echo "===== [ 目前的 sysctl 設定 ] ====="
sysctl -a | grep -E 'fs.file-max|net.core.rmem_max|net.core.wmem_max|net.core.netdev_max_backlog|net.core.somaxconn|net.ipv4.tcp_tw_reuse|net.ipv4.tcp_fin_timeout|net.ipv4.tcp_max_syn_backlog|net.ipv4.tcp_fastopen|net.ipv4.tcp_congestion_control|net.netfilter.nf_conntrack_max'
