fetch('https://jsonplaceholder.typicode.com/todos/1')  // 這裡換成你想抓的 API URL
  .then(response => {
    if (!response.ok) {  // 檢查回應狀態，確保是 200 OK
      throw new Error(`HTTP error! Status: ${response.status}`);
    }
    return response.json();  // 轉換回應成 JSON
  })
  .then(data => {
    console.log('API 資料:', data);  // 印出整個回應資料
    // 例如，如果你想抓特定欄位，像 IP 和國家，可以這樣：
    // console.log(data.ip, data.country);
  })
  .catch(error => {
    console.error('抓取 API 時出問題咧:', error);  // 捕捉錯誤並印出來
  });
