async function fetchExampleData() {
  try {
    const request = await fetch('https://jsonplaceholder.typicode.com/todos/1');  // 這裡用 jsonplaceholder 的 endpoint，換成你想用的 URL
    if (!request.ok) {  // 檢查回應狀態，確保沒問題
      throw new Error(`HTTP error! Status: ${request.status}`);
    }
    const jsonResponse = await request.json();  // 轉換回應成 JSON
    console.log('ID:', jsonResponse.id);  // 印出特定欄位，比原來的 IP 換成 ID
    console.log('標題:', jsonResponse.title);  // 印出標題，類似原來的國家欄位
  } catch (error) {
    console.error('抓 API 時出問題咧:', error);  // 如果有錯誤，就印出來
  }
}

// 執行函式
fetchExampleData();  // 記得這要在 async 環境下跑，比如在 async function 或 script 裡
