#!/bin/bash

# 請將 'new_hostname' 替換為你要設定的新主機名稱
NEW_HOSTNAME="new_hostname"

# 獲取原本的主機名稱
OLD_HOSTNAME=$(hostname)

# 刪除 /etc/hosts 中原本的主機名稱
sudo sed -i "/127.0.0.1 $OLD_HOSTNAME/d" /etc/hosts

# 更改主機名稱
sudo hostnamectl set-hostname $NEW_HOSTNAME

# 更新 /etc/hosts 文件
echo "127.0.0.1 $NEW_HOSTNAME" | sudo tee -a /etc/hosts > /dev/null

echo "主機名稱已從 $OLD_HOSTNAME 更改為 $NEW_HOSTNAME ，並已更新 /etc/hosts 文件。"

