#!/bin/bash

# 建立 aapanel 目錄並進入
mkdir -p aapanel && cd aapanel

# 下載 aaPanel Docker 映像
docker pull aapanel/aapanel:lib

# 啟動 aaPanel 容器
docker run -d --rm --name aapanel aapanel/aapanel:lib

# 等待容器啟動
sleep 5

# 從容器內部拷貝 www、etc、var、usr 目錄
docker exec aapanel tar Ccf / - www etc var usr | tar Cxf . -

# 停止 aaPanel 容器
docker stop aapanel

# 啟動 aaPanel 容器（使用拷貝後的目錄）
docker run -d --name aapanel --network="host" \
  --restart=always \
  -e TZ=Asia/Taipei \
  -v "$(pwd)"/www:/www \
  -v "$(pwd)"/etc:/etc \
  -v "$(pwd)"/var:/var \
  -v "$(pwd)"/usr:/usr \
  aapanel/aapanel:lib

# 顯示訪問網址
echo "\nAaPanel 安裝完成，可使用以下網址訪問："
echo "本機測試: http://127.0.0.1:7800/aapanel/"
echo "請確認您的伺服器 IP，然後使用: http://<你的伺服器IP>:7800/aapanel/\n"

echo "預設使用者名稱: aapanel"
echo "密碼可能會在安裝時自動產生，可以進入容器內手動重設："
echo "docker exec -it aapanel bash"
echo "cd /www/server/panel && python tools.py panel <你的新密碼>"
