import random


def toss_coin():
    # 0代表正面，1代表反面
    return "正面" if random.randint(0, 1) == 0 else "反面"


def simulate_tosses(n):
    # 初始化計數器
    count_heads = 0
    count_tails = 0

    # 擲硬幣n次
    for _ in range(n):
        result = toss_coin()
        if result == "正面":
            count_heads += 1
        else:
            count_tails += 1

    # 計算機率並轉換為百分比
    prob_heads = round((count_heads / n) * 100, 2)
    prob_tails = round((count_tails / n) * 100, 2)

    print(f"正面出現的機率是：{prob_heads}%")
    print(f"反面出現的機率是：{prob_tails}%")


# 呼叫函數，擲硬幣1000000次
simulate_tosses(1000000)
