from time import sleep
from datetime import datetime

class Clock(object):
    """Digital Clock"""

    def __init__(self, hour=0, minute=0, second=0):
        """Initialization method

        :param hour: Hour
        :param minute: Minute
        :param second: Second
        """
        self._hour = hour
        self._minute = minute
        self._second = second

    def run(self):
        self._second += 1
        if self._second == 60:
            self._second = 0
            self._minute += 1
            if self._minute == 60:
                self._minute = 0
                self._hour += 1
                if self._hour == 24:
                    self._hour = 0

    def show(self):
        """Show time"""
        return "%02d:%02d:%02d" % (self._hour, self._minute, self._second)


def main():
    now = datetime.now()
    clock = Clock(now.hour, now.minute, now.second)
    while True:
        print("\r" + clock.show(), end="")
        sleep(1)
        clock.run()


if __name__ == "__main__":
    main()

