# 使用 Homebrew 安裝 pyenv，這是一個 Python 版本管理工具
brew install pyenv

# 從 pyenv.run 下載並執行安裝腳本，來安裝 pyenv
curl https://pyenv.run | bash

# 設定 PYENV_ROOT 環境變數，指向 pyenv 的安裝目錄
export PYENV_ROOT="$HOME/.pyenv"

# 將 pyenv 的二進制目錄加入 PATH 環境變數，使其可執行
export PATH="$PYENV_ROOT/bin:$PATH"

# 初始化 pyenv 的路徑設定
eval "$(pyenv init --path)"

# 初始化 pyenv 的 shell 環境，使其可以管理 Python 版本
eval "$(pyenv init -)"

# 使用 pyenv 安裝 Python 3.12.2 版本
pyenv install 3.12.2

# 設定目前 shell 工作階段使用 Python 3.12.2 版本
pyenv shell 3.12.2

# 檢查目前使用的 Python 版本
python --version

# 設定目前目錄的 Python 版本為 3.12.2，會在該目錄下建立 .python-version 檔案
pyenv local 3.12.2
