from concurrent.futures import ThreadPoolExecutor, as_completed
import time

def task(n):
    """模擬一個耗時任務"""
    time.sleep(n)
    return f"Task {n} completed after {n} seconds"

# 建立執行緒池
with ThreadPoolExecutor(max_workers=3) as executor:
    futures = {executor.submit(task, i): i for i in range(1, 4)}

    for future in as_completed(futures):
        result = future.result()
        print(result)
