# 從 astral.sh 下載並執行安裝腳本，來安裝 uv 工具
curl -Ls https://astral.sh/uv/install.sh | sh

brew install uv

# 創建一個新的虛擬環境
uv venv

# 使用 uv 的 pip 安裝 requests 套件
uv pip install requests

# 將當前安裝的套件及其版本輸出到 requirements.txt 檔案
uv pip freeze > requirements.txt

# 從 requirements.txt 檔案安裝所需的套件
uv pip install -r requirements.txt

# 創建一個新的虛擬環境並從 requirements.txt 安裝套件
uv venv && uv pip install -r requirements.txt

# 移除現有的虛擬環境
uv venv --remove

# 同步虛擬環境中的套件，確保它們符合 requirements.txt 中的指定
uv pip sync

# 使用 uv 執行 Python 程式碼，輸出 requests 套件的版本
uv python -c "import requests; print(requests.__version__)"

# 從 requirements.in 檔案生成 requirements.txt，通常用於管理依賴項
uv pip compile requirements.in


# 建立一個新資料夾 myproject 並切換到該資料夾
mkdir myproject && cd myproject || exit

# 使用 uv 建立虛擬環境
uv venv

# 啟動虛擬環境
source .venv/bin/activate

# 安裝 numpy 和 pandas 套件
uv pip install numpy pandas

# 將目前安裝的套件及版本寫入 requirements.txt
uv pip freeze > requirements.txt



# 更新 uv 自身
uv self update

# 初始化一個範例 uv 專案
uv init example

# 進入範例專案資料夾
cd example || exit

# 安裝 ruff（Python 程式碼靜態分析工具）
uv add ruff

# 重新解析所有依賴並更新 lockfile（鎖定依賴版本）
uv lock

# 根據 lockfile 安裝所有套件，並執行安全性稽核
uv sync



# 啟動互動式 Python 介面（使用 uv）
uv run python

# 安裝特定版本的 Python：3.10、3.11、3.12
uv python install 3.10 3.11 3.12



# 建立一個簡單的 Python 檔案，並請求一個網頁
echo 'import requests; print(requests.get("https://astral.sh"))' > example.py

# 對 example.py 使用 uv 安裝所需的 requests 套件
uv add --script example.py requests



# 執行 pycowsay 指令顯示 "hello world!"（以小牛圖示顯示訊息）
uvx pycowsay 'hello world!'


# 使用 Docker 執行 uv CLI 並顯示說明文件
docker run --rm -it ghcr.io/astral-sh/uv:debian uv --help
