# 從 astral.sh 下載並執行安裝腳本，來安裝 uv 工具
curl -Ls https://astral.sh/uv/install.sh | sh

# 創建一個新的虛擬環境
uv venv

# 使用 uv 的 pip 安裝 requests 套件
uv pip install requests

# 將當前安裝的套件及其版本輸出到 requirements.txt 檔案
uv pip freeze > requirements.txt

# 從 requirements.txt 檔案安裝所需的套件
uv pip install -r requirements.txt

# 創建一個新的虛擬環境並從 requirements.txt 安裝套件
uv venv && uv pip install -r requirements.txt

# 移除現有的虛擬環境
uv venv --remove

# 同步虛擬環境中的套件，確保它們符合 requirements.txt 中的指定
uv pip sync

# 使用 uv 執行 Python 程式碼，輸出 requests 套件的版本
uv python -c "import requests; print(requests.__version__)"

# 從 requirements.in 檔案生成 requirements.txt，通常用於管理依賴項
uv pip compile requirements.in
