# 從 astral.sh 抓安裝腳本，直接裝 uv 工具，簡單又快速
curl -Ls https://astral.sh/uv/install.sh | sh

# 或者用 brew 安裝，Mac 用戶的最愛
brew install uv

# 創一個新的虛擬環境，隔離專案依賴，免得搞亂
uv venv

# 用 uv 的 pip 安裝 requests 套件，抓資料超好用
uv pip install requests

# 把目前裝的套件跟版本通通寫到 requirements.txt，備份一下
uv pip freeze > requirements.txt

# 從 requirements.txt 安裝套件，幫你一次搞定依賴
uv pip install -r requirements.txt

# 直接創虛擬環境再裝 requirements.txt 的套件，一氣呵成
uv venv && uv pip install -r requirements.txt

# 虛擬環境不要了？直接砍掉重練，沒問題
uv venv --remove

# 同步虛擬環境的套件，跟 requirements.txt 保持一致，免得出包
uv pip sync

# 用 uv 跑 Python 程式碼，秀一下 requests 的版本，確認有裝好
uv python -c "import requests; print(requests.__version__)"

# 從 requirements.in 生出 requirements.txt，管理依賴超方便
uv pip compile requirements.in

# 建一個新資料夾 myproject，直接切過去，準備好了
mkdir myproject && cd myproject || exit

# 用 uv 建虛擬環境，專案環境獨立起來，比較安全
uv venv

# 啟動虛擬環境，開始搞事情
source .venv/bin/activate

# 裝 numpy 跟 pandas，數據分析的好幫手
uv pip install numpy pandas

# 又來備份套件清單到 requirements.txt，免得忘記裝啥
uv pip freeze > requirements.txt

# 更新 uv 自己，保持最新版本，免得落後
uv self update

# 初始化一個範例專案 example，給新手練手用的
uv init example

# 進到範例專案資料夾，準備開工
cd example || exit

# 裝 ruff，Python 程式碼靜態分析工具，幫你檢查 code 品質
uv add ruff

# 重新解析依賴，更新 lockfile，鎖定版本，免得亂掉
uv lock

# 照 lockfile 安裝套件，還順便跑安全稽核，幫你顧好
uv sync

# 開個互動式 Python，用 uv 跑，測試一下環境
uv run python

# 裝特定版本的 Python，3.10、3.11、3.12 一次來，隨你挑
uv python install 3.10 3.11 3.12

# 寫個簡單 Python 檔案，抓 astral.sh 網站試試看
echo 'import requests; print(requests.get("https://astral.sh"))' > example.py

# 針對 example.py 裝 requests，uv 直接幫你處理依賴，挺貼心
uv add --script example.py requests

# 用 uvx 跑 pycowsay，秀個 "hello world!"，小牛圖案超可愛
uvx pycowsay 'hello world!'

# 用 Docker 跑 uv CLI，看看說明文件，測試環境也 OK
docker run --rm -it ghcr.io/astral-sh/uv:debian uv --help
