#!/bin/bash

# 使用 docker-compose 啟動所有服務，並在任一容器退出時中止
docker-compose up --abort-on-container-exit

# 啟動 mssql-server 服務
docker-compose up mssql-server

# 在後台啟動 mssql-server 服務
docker-compose up -d mssql-server

# 執行 sqlcmd 工具來連接到 mssql-server
docker-compose run sqlcmd

# 使用 sqlcmd 執行查詢，獲取 SQL Server 版本資訊
docker-compose run sqlcmd -S mssql-server -U sa -P StrongP@ssw0rd! -Q "SELECT @@VERSION"

# 使用 sqlcmd 工具連接到 mssql-server，添加一個鏈接伺服器
docker-compose run sqlcmd -S mssql-server -U sa -P StrongP@ssw0rd! -Q "
EXEC sp_addlinkedserver 
    @server='MyLinkedServer', 
    @srvproduct='', 
    @provider='SQLNCLI', 
    @datasrc='192.168.1.100', 
    @catalog='TargetDB';

EXEC sp_addlinkedsrvlogin 
    @rmtsrvname='MyLinkedServer', 
    @useself='false', 
    @rmtuser='remote_user', 
    @rmtpassword='remote_password';
"

# 使用 sqlcmd 工具連接到 mssql-server，查詢所有已鏈接的伺服器
docker-compose run sqlcmd -S mssql-server -U sa -P StrongP@ssw0rd! -Q "EXEC sp_linkedservers"

# 使用 sqlcmd 工具連接到 mssql-server，查詢特定鏈接伺服器的詳細資訊
docker-compose run sqlcmd -S mssql-server -U sa -P StrongP@ssw0rd! -Q "
SELECT * FROM sys.servers WHERE name = 'MyLinkedServer';
"
