from pywebio import start_server
from pywebio.input import FLOAT, input  # 引入 pywebio 模組中的 FLOAT 資料型態和 input 函數
from pywebio.output import put_text  # 引入 pywebio 模組中的 put_text 函數

def bmi():
    # 輸入身高和體重
    height = input("您的身高(cm)：", type=FLOAT)
    weight = input("您的體重(kg)：", type=FLOAT)

    # 計算 BMI
    BMI = weight / (height / 100) ** 2

    # BMI 分類及其對應的範圍
    top_status = [(14.9, "嚴重體重不足"), (18.4, "體重過輕"), (22.9, "正常體重"), 
                  (27.5, "體重過重"), (40.0, "中度肥胖"), (float("inf"), "嚴重肥胖")]

    # 判斷 BMI 位於哪個分類範圍內，並顯示結果
    for top, status in top_status:
        if BMI <= top:
            put_text("您的 BMI: %.1f, 分類: %s" % (BMI, status))
            break

if __name__ == "__main__":
    start_server(bmi, port=8080)

