"""
這段程式碼是建立一個執行緒來處理工作項目，並將 30 個工作項目放入工作佇列中。然後會等待所有工作都完成後才會印出 "All work completed" 的訊息。
"""

import threading
import queue


# 定義一個函式來處理工作項目
def process_work_item(work_queue):
    # 在這裡添加你的工作處理代碼
    while not work_queue.empty():
        # 從工作佇列中取出一個工作項目
        work_item = work_queue.get()

        # 在這裡添加你的工作處理代碼
        pass
        print(work_item)

        # 通知工作佇列，已經處理完一個工作項目
        work_queue.task_done()



# 建立工作佇列
work_queue = queue.Queue()

# 將 30 個工作項目放入工作佇列中
for i in range(30):
    work_queue.put(i)

# 建立執行緒
worker = threading.Thread(target=process_work_item, args=(work_queue,))

# 啟動執行緒
worker.start()

# 等待執行緒結束
worker.join()

# 印出完成訊息
print("All work completed")

