import tempfile

# 使用 NamedTemporaryFile 建立暫存檔案
with tempfile.NamedTemporaryFile(delete=False) as temp_file:
    # 在暫存檔案中寫入一些內容
    temp_file.write(b'Hello, this is a temporary file example.')

    # 獲取暫存檔案的路徑
    temp_file_path = temp_file.name

    # 在這裡可以進行對暫存檔案的操作，例如讀取或修改內容

# 暫存檔案會在離開上下文管理器後自動刪除，因為 delete 參數預設為 True
