import socket

def is_connected(host='8.8.8.8', port=53, timeout=3):
    """
    嘗試連線到指定的 host 與 port，預設為 Google 的 DNS 伺服器。
    """
    try:
        socket.setdefaulttimeout(timeout)
        s = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
        s.connect((host, port))
        s.close()
        return True
    except socket.error:
        return False

if __name__ == '__main__':
    if is_connected():
        print("網路連線正常")
    else:
        print("網路連線有問題")
