import errno

ERRORS = {
    errno.ENOENT: "檔案或目錄不存在",
    errno.EACCES: "權限不足",
    errno.EEXIST: "檔案已存在",
    errno.ENOTDIR: "非目錄",
}

def check_error(code):
    return ERRORS.get(code, "未知錯誤")

print(check_error(errno.ENOENT))  # 檔案或目錄不存在
print(check_error(9999))  # 未知錯誤
