import yaml
import json
from abc import ABC, abstractmethod

# 策略介面
class DataHandlerStrategy(ABC):
    @abstractmethod
    def read_data(self, path):
        pass

    @abstractmethod
    def write_data(self, path, data):
        pass


# YAML 策略
class YamlHandler(DataHandlerStrategy):
    def read_data(self, path):
        with open(path, "r") as f:
            return yaml.safe_load(f)

    def write_data(self, path, data):
        with open(path, "w") as f:
            yaml.safe_dump(data, f)


# JSON 策略
class JsonHandler(DataHandlerStrategy):
    def read_data(self, path):
        with open(path, "r") as f:
            return json.load(f)

    def write_data(self, path, data):
        with open(path, "w") as f:
            json.dump(data, f, ensure_ascii=False, indent=4)
