import psutil

# 獲取 CPU 使用率
cpu_usage = psutil.cpu_percent(interval=1)
print(f"CPU 使用率: {cpu_usage}%")

# 獲取記憶體資訊
memory_info = psutil.virtual_memory()
print(f"總記憶體: {memory_info.total / (1024**3):.2f} GB")
print(f"可用記憶體: {memory_info.available / (1024**3):.2f} GB")
print(f"記憶體使用率: {memory_info.percent}%")

# 獲取磁碟使用狀況
disk_info = psutil.disk_usage("/")
print(f"磁碟總空間: {disk_info.total / (1024**3):.2f} GB")
print(f"磁碟可用空間: {disk_info.free / (1024**3):.2f} GB")
print(f"磁碟使用率: {disk_info.percent}%")

# 獲取網路流量
net_info = psutil.net_io_counters()
print(f"已發送: {net_info.bytes_sent / (1024**2):.2f} MB")
print(f"已接收: {net_info.bytes_recv / (1024**2):.2f} MB")
